--Barnsley Fern
-- A demo for Lua Turtle 

--The following table stores the four possible transformations which make
-- up the fern. Each of these is applied with a certain probability (see 
-- GetNextP() for details)
local t = { { 0.85, 0.04,-0.04, 0.85, 0.0,  1.6  },		--weight: 85%
            { 0.2, -0.26, 0.23, 0.22, 0.0,  1.6  },		--weight:  7%
            {-0.15, 0.28, 0.26, 0.24, 0.0,  0.44 },		--weight:  7%
            { 0.0,  0.0,  0.0,  0.16, 0.0,  0.0  } };	--weight:  1%
local P = {X=0, Y=0};
            
function GetNextP(oldp)		--applies a transformation to oldp and returns the new point
	local ret = {X=0, Y=0};
	--Randomly choose a transformation:
	local rand = math.random(1, 100);
	if(rand <= 85) then rand = 1; elseif(rand <= 92) then rand = 2 elseif(rand <= 99) then rand = 3 else rand = 4 end
	local trans = t[rand];
	
	--Affine transformation of P:
	ret.X = trans[1]*oldp.X + trans[2]*oldp.Y + trans[5];
	ret.Y = trans[3]*oldp.X + trans[4]*oldp.Y + trans[6];
	return ret;
end

--Program entry
--Init randomizer:
math.randomseed( os.time() );
math.random(); math.random(); math.random();	--the first numbers are usually not very good, so we discard them

--Start
local scale = 55;
print("Barnsley's Fractal Fern");
for iter=1, 50000 do	--one point per iteration
	turtle.PenUp();
	turtle.SetColor(95*math.abs(P.X), 210, 96*math.abs((5-P.Y)/5));
	turtle.Goto(P.X*scale, (P.Y*scale)-300);
	turtle.PenDown();
	turtle.Go(1);
	P = GetNextP(P);
end